<?php

/**
 * valio-theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package valio-theme
 */

if (!defined('VALIOTHEME_VERSION')) {
	// Replace the version number of the theme on each release.
	define('VALIOTHEME_VERSION', '1.0.0');
}

if (!function_exists('valio_theme_setup')) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function valio_theme_setup() {
		add_theme_support('title-tag'); // Gère automatiquement les titres
		add_theme_support('post-thumbnails'); // Images à la une
		register_nav_menus(array(
			'main-menu' => 'Menu Principal',
			'footer-menu' => 'Menu Footer',
			'legal-menu' => 'Menu Légal',
		));
	}
endif;
add_action('after_setup_theme', 'valio_theme_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function valio_theme_content_width() {
	$GLOBALS['content_width'] = apply_filters('valio_theme_content_width', 640);
}
add_action('after_setup_theme', 'valio_theme_content_width', 0);

/**
 * Enqueue scripts and styles.
 */
function valio_enqueue_assets() {
    wp_enqueue_style('valio-style', get_stylesheet_uri());
    wp_enqueue_script('valio-scripts', get_template_directory_uri() . '/js/scripts.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'valio_enqueue_assets');

#############################################################

function themename_custom_logo_setup() {
	$defaults = array(
		'height'               => 100,
		'width'                => 400,
		'flex-height'          => true,
		'flex-width'           => true,
		'header-text'          => array( 'site-title', 'site-description' ),
		'unlink-homepage-logo' => true, 
	);
	add_theme_support( 'custom-logo', $defaults );
}
add_action( 'after_setup_theme', 'themename_custom_logo_setup' );

function valiotheme_init() {
	register_post_type('event', [
		'labels' => array (
			'name' => 'Evenements',
			'singular_name' => 'Evenement',
			'edit_item' => 'Modifier',
			'add_new' => 'Ajouter',
			'add_new_item' => 'Ajouter un évenement',
			'all_items' => 'Tous les évenements',
			'not_found' => 'Aucun évenement trouvé',
		),
		'public' => true,
		'show_in_rest' => true,
		'has_archive' => true,
		'menu_position' => 4,
		'show_in_nav_menus' => true,
		'menu_icon' => 'dashicons-megaphone',
		'supports' => ['title', 'editor', 'excerpt']
	]);

	register_post_type('axe', [
		'labels' => array (
			'name' => 'Axes',
			'singular_name' => 'Axe',
			'edit_item' => 'Modifier',
			'add_new' => 'Ajouter',
			'add_new_item' => 'Ajouter un axe',
			'all_items' => 'Tous les axes',
			'not_found' => 'Aucun axe trouvé',
		),
		'public' => true,
		'show_in_rest' => true,
		'has_archive' => true,
		'menu_position' => 5,
		'show_in_nav_menus' => true,
		'menu_icon' => 'dashicons-buddicons-groups',
		'taxonomies' => array('category'),
		'supports' => ['title', 'editor', 'category']
	]);
}

add_action('init', 'valiotheme_init');

require_once('metaboxes/event.php');

EventMetabox::register();

/**
 * Register all shortcodes
 *
 * @return null
 */
function register_shortcodes() {
    add_shortcode( 'events', 'shortcode_events' );
    add_shortcode( 'axes', 'shortcode_axes' );
}
add_action( 'init', 'register_shortcodes' );

function shortcode_events() {
	ob_start();
    $query = new WP_Query( array(
        'post_type' => 'event',
        'color' => 'blue',
        'posts_per_page' => -1,
        'meta_key' => 'valiotheme_event_date',
		'orderby' => 'meta_value',
		'order' => 'ASC',
		'meta_query' => array(
			array(
			'key' => 'valiotheme_event_date',
			'compare' => 'LIKE',
			)
		)
    ) );
    if ( $query->have_posts() ) { ?>
	<div class="events-container">
		<div class="events-list">
			<?php
				while ( $query->have_posts() ) : 
					$query->the_post();
					$post_id = get_the_ID();
			?>
				<div class="event-item">
					<div class="event-info">
						<div class="event-date"><?php echo get_post_meta($post_id, 'valiotheme_event_textdate', true); ?></div>
						<h4><?php the_title(); ?></h4>
					</div>
					<p><?php the_excerpt(); ?></p>
				</div>
			<?php endwhile;
			wp_reset_postdata(); ?>
		</div>
	</div>
    <?php $myvariable = ob_get_clean();
    return $myvariable;
    }
}

function shortcode_axes() {
	ob_start();
	$args = array(
		'parent' => 5,
		'orderby' => 'ID',
	);

	$sub_cats = get_categories( $args );

	if($sub_cats)
	{ ?>
		<div class="axes-container">
			<ul class="axes-categories">
				<?php foreach($sub_cats as $sub_category)
				{ ?>
					<li class="category" data-slug="<?php echo $sub_category->slug; ?>" data-id="<?php echo $sub_category->term_id; ?>"><?php echo $sub_category->cat_name; ?></li>
				<?php } ?>
			</ul>
			<?php
				$query = new WP_Query( array(
					'post_type' => 'axe',
					'color' => 'blue',
					'posts_per_page' => -1,
					'orderby' => 'ID',
					'order' => 'ASC',
				) );
			if ( $query->have_posts() ) { ?>
				<div class="axes-list">
					<?php
						$i=1;
						while ( $query->have_posts() ) : 
							$query->the_post();
							$post_id = get_the_ID();
					?>
						<div class="axes-item">
							<div class="axe-id"><?php echo $i; ?></div>
							<div class="axe-info">
								<h4><?php the_title(); ?></h4>
								<div><?php the_content(); ?></div>
							</div>
						</div>
					<?php $i++;
					endwhile;
					wp_reset_postdata(); ?>
				</div>
			</div>
			<?php $myvariable = ob_get_clean();
			return $myvariable;
			}
	}
}

// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

	global $wp_version;
	if ( $wp_version !== '4.7.1' ) {
	   return $data;
	}
  
	$filetype = wp_check_filetype( $filename, $mimes );
  
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
	echo '<style type="text/css">
		  .attachment-266x266, .thumbnail img {
			   width: 100% !important;
			   height: auto !important;
		  }
		  </style>';
  }
  add_action( 'admin_head', 'fix_svg' );