<?php
class EventMetabox {

  const LINK_KEY = 'valiotheme_event_link';
  const DATE_KEY = 'valiotheme_event_date';
  const TEXTDATE_KEY = 'valiotheme_event_textdate';

  public static function register() {
    add_action('add_meta_boxes', [self::class, 'add']);
    add_action('save_post', [self::class, 'save']);
  }

  public static function add() {
    add_meta_box(self::LINK_KEY, 'Lien d\'inscription', [self::class, 'render_event_link'], 'event', 'normal', 'high');
    add_meta_box(self::DATE_KEY, 'Date de l\'événement (pour le classement par date)', [self::class, 'render_event_date'], 'event', 'normal', 'high');
    add_meta_box(self::TEXTDATE_KEY, 'Date de l\'événement (en toutes lettres, pour l\'affichage sur le site)', [self::class, 'render_event_textdate'], 'event', 'normal', 'high');
  }

  public static function render_event_link($post) {
    $value = get_post_meta($post->ID, self::LINK_KEY, true);
?>
    <input type="text" name="<?= self::LINK_KEY ?>" id="valiotheme_event_link" value="<?= $value ?>">
<?php
  }

  public static function render_event_date($post) {
    $value = get_post_meta($post->ID, self::DATE_KEY, true);
?>
    <input type="date" name="<?= self::DATE_KEY ?>" id="valiotheme_event_date" value="<?= $value ?>">
<?php
  }

  public static function render_event_textdate($post) {
    $value = get_post_meta($post->ID, self::TEXTDATE_KEY, true);
?>
    <input type="text" name="<?= self::TEXTDATE_KEY ?>" id="valiotheme_event_textdate" value="<?= $value ?>">
<?php
  }

  public static function save($post_id) {
    if (isset($_POST[self::LINK_KEY])) {
      $link_sanitized = sanitize_text_field($_POST[self::LINK_KEY]);
      update_post_meta($post_id, self::LINK_KEY, $link_sanitized);
    }
    if (isset($_POST[self::DATE_KEY])) {
      $date_sanitized = sanitize_text_field($_POST[self::DATE_KEY]);
      update_post_meta($post_id, self::DATE_KEY, $date_sanitized);
    }
    if (isset($_POST[self::TEXTDATE_KEY])) {
      $textdate_sanitized = sanitize_text_field($_POST[self::TEXTDATE_KEY]);
      update_post_meta($post_id, self::TEXTDATE_KEY, $textdate_sanitized);
    }
  }
}
